//
//  NSError.h
//  AnotherKyoponUtilities
//
//  Created by FUJIDANA on 06/08/07.
//  Copyright 2006 FUJIDANA. All rights reserved.
//


#import <Foundation/Foundation.h>


/*!
 @constant WXKErrorDomain
 @abstract Errors occurred in WXKPhone.
*/
extern NSString *const WXKErrorDomain;

/*!
 @enum Phone Errors
 @abstract Error Codes
 @discussion These codes are generated when the error occurs in communicating to a cellphone.  
 @constant WXKPhoneGenericError Generic error
 @constant WXKPhoneConnectionError A phone is not physically connected to a compulter
 @constant WXKPhoneOpenPortError Fail to open a port to a cellphone
 @constant WXKPhoneConfigurePortError Fail to change a port configuration
*/

enum {
	WXKPhoneGenericError,
	WXKPhoneConnectionError = 1,
	WXKPhoneOpenPortError,
	WXKPhoneConfigurePortError,
	WXKPhoneInapplicableDataLengthReceivedError,
	WXKPhoneNotReadyError,
	WXKPhoneReadSerialPortError,
	WXKPhoneWriteSerialPortError,
	WXKPhoneIncorrectPasswordError, 
	WXKPhoneInapplicableDataReceivedError,
	WXKPhoneInapplicablePasswordStringEncodingError, 
	WXKPhoneInapplicablePasswordStringLengthError,
	WXKPhoneNotLoggedInError,
	WXKPhoneMalformedItemReceivedError,
	WXKPhoneMalformedItemSentError,
	WXKPhoneTooManyItemsSendingError,
	WXKPhoneUserCancelledError
};
